
@extends('layout')

@section('title')
    <title>{{ __('translate.Payment') }}</title>
@endsection

@section('front-content')

    <!-- Main Start -->
    <main>
        <!-- Breadcrumb -->
        <section class="w-breadcrumb-area" style="background-image: url({{ asset($general_setting->breadcrumb_image) }});">
          <div class="container">
            <div class="row">
              <div class="col-auto">
                <div
                  class="position-relative z-2"
                  data-aos="fade-up"
                  data-aos-duration="1000"
                  data-aos-easing="linear"
                >
                  <h2 class="section-title-light mb-2">{{ __('translate.Payment') }}</h2>
                  <nav aria-label="breadcrumb">
                    <ol class="breadcrumb w-breadcrumb">
                      <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                      <li class="breadcrumb-item active" aria-current="page">
                        {{ __('translate.Payment') }}
                      </li>
                    </ol>
                  </nav>
                </div>
              </div>
            </div>
          </div>
        </section>
        <!-- Breadcrumb End -->

        
        <!-- Plan Start -->
      <section class="subscription-plan bg-offWhite py-110">
        <div class="container">
            <div class="row g-4">
                @foreach ($plans as $index => $plan )
                    <article class="col-xl-3 col-md-6">
                        <div class="plan-table bg-white">
                            <div class="plan-header d-flex align-items-center justify-content-between bg-offWhite" >
                            <div>
                                <h3 class="text-24 fw-bold text-dark-300">{{ $plan->plan_name }}</h3>
                                <h2 class="text-40 fw-bold">
                                {{ currency($plan->plan_price) }}
                                <span class="text-18 fw-normal">/
                                    @if ($plan->expiration_date == 'monthly')
                                    {{__('translate.Monthly')}}
                                    @elseif ($plan->expiration_date == 'yearly')
                                    {{__('translate.Yearly')}}
                                    @elseif ($plan->expiration_date == 'lifetime')
                                    {{__('translate.Lifetime')}}
                                    @endif
                                </span>
                                </h2>
                            </div>
                            
                            </div>
                            <div class="plan-body mt-40 mb-40">
                            <ul>
                                <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200 fs-6 text-dark-200" >
                                    <svg
                                        xmlns="http://www.w3.org/2000/svg"
                                        width="14"
                                        height="14"
                                        viewBox="0 0 14 14"
                                        fill="none"
                                    >
                                        <circle cx="7" cy="7.00012" r="7" fill="#22BE0D" />
                                        <path
                                        d="M10.5269 4.36659C10.4746 4.31382 10.4123 4.27194 10.3437 4.24337C10.2751 4.21479 10.2016 4.20007 10.1272 4.20007C10.0529 4.20007 9.97936 4.21479 9.91076 4.24337C9.84216 4.27194 9.7799 4.31382 9.72757 4.36659L5.53378 8.56601L3.77182 6.79843C3.71748 6.74594 3.65334 6.70467 3.58306 6.67697C3.51278 6.64927 3.43772 6.63569 3.36219 6.637C3.28666 6.6383 3.21212 6.65447 3.14284 6.68459C3.07355 6.7147 3.01088 6.75816 2.95839 6.8125C2.9059 6.86683 2.86463 6.93097 2.83694 7.00126C2.80924 7.07154 2.79565 7.14659 2.79696 7.22213C2.79827 7.29766 2.81444 7.3722 2.84455 7.44148C2.87467 7.51077 2.91813 7.57344 2.97246 7.62593L5.1341 9.78756C5.18643 9.84032 5.24869 9.8822 5.31729 9.91078C5.38589 9.93936 5.45946 9.95407 5.53378 9.95407C5.60809 9.95407 5.68167 9.93936 5.75026 9.91078C5.81886 9.8822 5.88112 9.84032 5.93345 9.78756L10.5269 5.19409C10.5841 5.14137 10.6297 5.0774 10.6609 5.00619C10.692 4.93498 10.7082 4.85808 10.7082 4.78034C10.7082 4.7026 10.692 4.6257 10.6609 4.55449C10.6297 4.48328 10.5841 4.4193 10.5269 4.36659Z"
                                        fill="white"
                                        />
                                    </svg>
                                    @if ($plan->max_listing == -1)
                                        {{ __('translate.Unlimited Service') }}
                                    @else
                                        {{ $plan->max_listing }} {{ __('translate.Service') }}
                                    @endif
                                </li>

                                @if ($plan->featured_listing > 0)
                                    <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200" >
                                        <svg
                                            xmlns="http://www.w3.org/2000/svg"
                                            width="14"
                                            height="14"
                                            viewBox="0 0 14 14"
                                            fill="none"
                                        >
                                            <circle cx="7" cy="7.00012" r="7" fill="#22BE0D" />
                                            <path
                                            d="M10.5269 4.36659C10.4746 4.31382 10.4123 4.27194 10.3437 4.24337C10.2751 4.21479 10.2016 4.20007 10.1272 4.20007C10.0529 4.20007 9.97936 4.21479 9.91076 4.24337C9.84216 4.27194 9.7799 4.31382 9.72757 4.36659L5.53378 8.56601L3.77182 6.79843C3.71748 6.74594 3.65334 6.70467 3.58306 6.67697C3.51278 6.64927 3.43772 6.63569 3.36219 6.637C3.28666 6.6383 3.21212 6.65447 3.14284 6.68459C3.07355 6.7147 3.01088 6.75816 2.95839 6.8125C2.9059 6.86683 2.86463 6.93097 2.83694 7.00126C2.80924 7.07154 2.79565 7.14659 2.79696 7.22213C2.79827 7.29766 2.81444 7.3722 2.84455 7.44148C2.87467 7.51077 2.91813 7.57344 2.97246 7.62593L5.1341 9.78756C5.18643 9.84032 5.24869 9.8822 5.31729 9.91078C5.38589 9.93936 5.45946 9.95407 5.53378 9.95407C5.60809 9.95407 5.68167 9.93936 5.75026 9.91078C5.81886 9.8822 5.88112 9.84032 5.93345 9.78756L10.5269 5.19409C10.5841 5.14137 10.6297 5.0774 10.6609 5.00619C10.692 4.93498 10.7082 4.85808 10.7082 4.78034C10.7082 4.7026 10.692 4.6257 10.6609 4.55449C10.6297 4.48328 10.5841 4.4193 10.5269 4.36659Z"
                                            fill="white"
                                            />
                                        </svg>
                                    {{ __('translate.Featured Service') }}
                                    </li>
                                @else
                                    <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200" >
                                        <svg
                                            xmlns="http://www.w3.org/2000/svg"
                                            width="14"
                                            height="14"
                                            viewBox="0 0 14 14"
                                            fill="none"
                                        >
                                            <circle cx="7" cy="7.00012" r="7" fill="#FF3838" />
                                            <path
                                            d="M10 4.00016L4 10.0001M10 10.0001L4 4.00012"
                                            stroke="white"
                                            stroke-width="1.2"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                            />
                                        </svg>
                                    {{ __('translate.Featured Service') }}
                                    </li>

                                @endif
                                <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200" >
                                    <svg
                                        xmlns="http://www.w3.org/2000/svg"
                                        width="14"
                                        height="14"
                                        viewBox="0 0 14 14"
                                        fill="none"
                                    >
                                        <circle cx="7" cy="7.00012" r="7" fill="#22BE0D" />
                                        <path
                                        d="M10.5269 4.36659C10.4746 4.31382 10.4123 4.27194 10.3437 4.24337C10.2751 4.21479 10.2016 4.20007 10.1272 4.20007C10.0529 4.20007 9.97936 4.21479 9.91076 4.24337C9.84216 4.27194 9.7799 4.31382 9.72757 4.36659L5.53378 8.56601L3.77182 6.79843C3.71748 6.74594 3.65334 6.70467 3.58306 6.67697C3.51278 6.64927 3.43772 6.63569 3.36219 6.637C3.28666 6.6383 3.21212 6.65447 3.14284 6.68459C3.07355 6.7147 3.01088 6.75816 2.95839 6.8125C2.9059 6.86683 2.86463 6.93097 2.83694 7.00126C2.80924 7.07154 2.79565 7.14659 2.79696 7.22213C2.79827 7.29766 2.81444 7.3722 2.84455 7.44148C2.87467 7.51077 2.91813 7.57344 2.97246 7.62593L5.1341 9.78756C5.18643 9.84032 5.24869 9.8822 5.31729 9.91078C5.38589 9.93936 5.45946 9.95407 5.53378 9.95407C5.60809 9.95407 5.68167 9.93936 5.75026 9.91078C5.81886 9.8822 5.88112 9.84032 5.93345 9.78756L10.5269 5.19409C10.5841 5.14137 10.6297 5.0774 10.6609 5.00619C10.692 4.93498 10.7082 4.85808 10.7082 4.78034C10.7082 4.7026 10.692 4.6257 10.6609 4.55449C10.6297 4.48328 10.5841 4.4193 10.5269 4.36659Z"
                                        fill="white"
                                        />
                                    </svg>
                                    {{ $plan->featured_listing }} {{ __('translate.Featured Service') }}
                                </li>


                                @if ($plan->recommended_seller == 'active')
                                    <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200" >
                                        <svg
                                            xmlns="http://www.w3.org/2000/svg"
                                            width="14"
                                            height="14"
                                            viewBox="0 0 14 14"
                                            fill="none"
                                        >
                                            <circle cx="7" cy="7.00012" r="7" fill="#22BE0D" />
                                            <path
                                            d="M10.5269 4.36659C10.4746 4.31382 10.4123 4.27194 10.3437 4.24337C10.2751 4.21479 10.2016 4.20007 10.1272 4.20007C10.0529 4.20007 9.97936 4.21479 9.91076 4.24337C9.84216 4.27194 9.7799 4.31382 9.72757 4.36659L5.53378 8.56601L3.77182 6.79843C3.71748 6.74594 3.65334 6.70467 3.58306 6.67697C3.51278 6.64927 3.43772 6.63569 3.36219 6.637C3.28666 6.6383 3.21212 6.65447 3.14284 6.68459C3.07355 6.7147 3.01088 6.75816 2.95839 6.8125C2.9059 6.86683 2.86463 6.93097 2.83694 7.00126C2.80924 7.07154 2.79565 7.14659 2.79696 7.22213C2.79827 7.29766 2.81444 7.3722 2.84455 7.44148C2.87467 7.51077 2.91813 7.57344 2.97246 7.62593L5.1341 9.78756C5.18643 9.84032 5.24869 9.8822 5.31729 9.91078C5.38589 9.93936 5.45946 9.95407 5.53378 9.95407C5.60809 9.95407 5.68167 9.93936 5.75026 9.91078C5.81886 9.8822 5.88112 9.84032 5.93345 9.78756L10.5269 5.19409C10.5841 5.14137 10.6297 5.0774 10.6609 5.00619C10.692 4.93498 10.7082 4.85808 10.7082 4.78034C10.7082 4.7026 10.692 4.6257 10.6609 4.55449C10.6297 4.48328 10.5841 4.4193 10.5269 4.36659Z"
                                            fill="white"
                                            />
                                        </svg>
                                        {{__('translate.Recommended Seller')}}
                                    </li>
                                @else
                                    <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200" >
                                        <svg
                                            xmlns="http://www.w3.org/2000/svg"
                                            width="14"
                                            height="14"
                                            viewBox="0 0 14 14"
                                            fill="none"
                                        >
                                            <circle cx="7" cy="7.00012" r="7" fill="#FF3838" />
                                            <path
                                            d="M10 4.00016L4 10.0001M10 10.0001L4 4.00012"
                                            stroke="white"
                                            stroke-width="1.2"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                            />
                                        </svg>
                                        {{__('translate.Recommended Seller')}}
                                    </li>

                                @endif

                                <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200" >
                                    <svg
                                        xmlns="http://www.w3.org/2000/svg"
                                        width="14"
                                        height="14"
                                        viewBox="0 0 14 14"
                                        fill="none"
                                    >
                                        <circle cx="7" cy="7.00012" r="7" fill="#22BE0D" />
                                        <path
                                        d="M10.5269 4.36659C10.4746 4.31382 10.4123 4.27194 10.3437 4.24337C10.2751 4.21479 10.2016 4.20007 10.1272 4.20007C10.0529 4.20007 9.97936 4.21479 9.91076 4.24337C9.84216 4.27194 9.7799 4.31382 9.72757 4.36659L5.53378 8.56601L3.77182 6.79843C3.71748 6.74594 3.65334 6.70467 3.58306 6.67697C3.51278 6.64927 3.43772 6.63569 3.36219 6.637C3.28666 6.6383 3.21212 6.65447 3.14284 6.68459C3.07355 6.7147 3.01088 6.75816 2.95839 6.8125C2.9059 6.86683 2.86463 6.93097 2.83694 7.00126C2.80924 7.07154 2.79565 7.14659 2.79696 7.22213C2.79827 7.29766 2.81444 7.3722 2.84455 7.44148C2.87467 7.51077 2.91813 7.57344 2.97246 7.62593L5.1341 9.78756C5.18643 9.84032 5.24869 9.8822 5.31729 9.91078C5.38589 9.93936 5.45946 9.95407 5.53378 9.95407C5.60809 9.95407 5.68167 9.93936 5.75026 9.91078C5.81886 9.8822 5.88112 9.84032 5.93345 9.78756L10.5269 5.19409C10.5841 5.14137 10.6297 5.0774 10.6609 5.00619C10.692 4.93498 10.7082 4.85808 10.7082 4.78034C10.7082 4.7026 10.692 4.6257 10.6609 4.55449C10.6297 4.48328 10.5841 4.4193 10.5269 4.36659Z"
                                        fill="white"
                                        />
                                    </svg>
                                    {{__('translate.Unlimited Job Apply')}}
                                </li>


                                <li class="d-flex align-items-center gap-3 py-1 fs-6 text-dark-200" >
                                    <svg
                                        xmlns="http://www.w3.org/2000/svg"
                                        width="14"
                                        height="14"
                                        viewBox="0 0 14 14"
                                        fill="none"
                                    >
                                        <circle cx="7" cy="7.00012" r="7" fill="#22BE0D" />
                                        <path
                                        d="M10.5269 4.36659C10.4746 4.31382 10.4123 4.27194 10.3437 4.24337C10.2751 4.21479 10.2016 4.20007 10.1272 4.20007C10.0529 4.20007 9.97936 4.21479 9.91076 4.24337C9.84216 4.27194 9.7799 4.31382 9.72757 4.36659L5.53378 8.56601L3.77182 6.79843C3.71748 6.74594 3.65334 6.70467 3.58306 6.67697C3.51278 6.64927 3.43772 6.63569 3.36219 6.637C3.28666 6.6383 3.21212 6.65447 3.14284 6.68459C3.07355 6.7147 3.01088 6.75816 2.95839 6.8125C2.9059 6.86683 2.86463 6.93097 2.83694 7.00126C2.80924 7.07154 2.79565 7.14659 2.79696 7.22213C2.79827 7.29766 2.81444 7.3722 2.84455 7.44148C2.87467 7.51077 2.91813 7.57344 2.97246 7.62593L5.1341 9.78756C5.18643 9.84032 5.24869 9.8822 5.31729 9.91078C5.38589 9.93936 5.45946 9.95407 5.53378 9.95407C5.60809 9.95407 5.68167 9.93936 5.75026 9.91078C5.81886 9.8822 5.88112 9.84032 5.93345 9.78756L10.5269 5.19409C10.5841 5.14137 10.6297 5.0774 10.6609 5.00619C10.692 4.93498 10.7082 4.85808 10.7082 4.78034C10.7082 4.7026 10.692 4.6257 10.6609 4.55449C10.6297 4.48328 10.5841 4.4193 10.5269 4.36659Z"
                                        fill="white"
                                        />
                                    </svg>
                                    {{__('translate.24/7 Hour Support')}}
                                </li>

                            </ul>
                            </div>
                            <div class="plan-footer">
                            <button
                                class="plan-footer-btn"
                                data-bs-toggle="modal"
                                data-bs-target="#buyModal"
                            >
                                Get Started<svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="18"
                                height="19"
                                viewBox="0 0 18 19"
                                fill="none"
                                >
                                <path
                                    d="M10.5 4.25012L15.75 9.50012M15.75 9.50012L10.5 14.7501M15.75 9.50012L2.25 9.50012"
                                    stroke="currentColor"
                                    stroke-width="2"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                </svg>
                            </button>
                            </div>
                        </div>
                    </article>
                @endforeach
            </div>
        </div>
      </section>
      <!-- Plan End -->


      </main>
      <!-- Main End -->
@endsection
